import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutation } from "../../util/apiRequest";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
    message: "",
    totalPrice: 0,
};

export const deleteGroupItems = createAsyncThunk(
    "cart/deleteGroupItems",
    async (obj) => {
        const { access_token, deleteGroupURL, method, data } = obj;
        const response = await mutationResponse(
            deleteGroupURL,
            method,
            data,
            access_token
        );
        return response;
    }
);

const deleteGroupItemsSlice = createSlice({
    name: "cart",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(deleteGroupItems.pending, (state) => {});
        builder.addCase(deleteGroupItems.fulfilled, (state, { payload }) => {});
        builder.addCase(deleteGroupItems.rejected, (state) => {});
    },
});

export default deleteGroupItemsSlice.reducer;
